"use client"
import LoadingCircle from "@/components/icons/loading.circle"
import { Button } from "@/components/ui/button"
import { revalidateAgencies } from "@/hooks/use-get-agencies"
import { invokePublishPreviewContentToLiveEnvironment } from "@/lib/actions"
import { minDelay } from "@/lib/timing"
import { Check } from "lucide-react"
import { useState } from "react"

type INTERNAL__ButtonState = undefined | "loading" | "success" | "error"

/**
 * React component to handling triggering preview to production workflows. Manages
 * AWS lambda functions which move files between preview environment to live open trip planner
 * servers.
 *
 * @deprecated Waiting on backend Step Function ARN before trigger preview to production workflow 
 */
export function BuildsButtonTriggerPublish() {
  const [state, setState] = useState<INTERNAL__ButtonState>(undefined)

  return (
    <Button
      onClick={async () => {
        setState('loading')
        try {
          await minDelay(invokePublishPreviewContentToLiveEnvironment(), 1500)
          await revalidateAgencies()
          setState('success')
        } catch (e) {
          setState('error')
        } finally {
          setTimeout(() => setState(undefined), 3000)
        }
      }}
      variant={"default"}
      size={"lg"}
      className="flex place-items-center gap-2"
      disabled={state !== undefined}
    >
      {INTERNAL__getButtonContent(state)}
    </Button>
  )
}

function INTERNAL__getButtonContent(state: INTERNAL__ButtonState) {
  if (!state) {
    return "Publish changes to live server."
  }

  if (state === 'loading') {
    return (
      <>
        Publish changes to live server.{" "}
        <LoadingCircle className="size-3" />
      </>
    )
  }

  if (state === 'success') {
    return (
      <>
        Successfully published changes.{" "}
        <Check className="size-3 animate-in fade-in" />
      </>
    )
  }

  return (
    <>
      Error ocurred while publishing changes.
    </>
  )
}
